define("core/comboboxsearch/search_combobox",["exports","jquery","core/utils","core/pending","core/str"],(function(_exports,_jquery,_utils,_pending,_str){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}
/**
   * The class that manages the state of the search within a combobox.
   *
   * @module    core/comboboxsearch/search_combobox
   * @copyright 2023 Mathew May <mathew.solutions>
   * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_jquery=_interopRequireDefault(_jquery),_pending=_interopRequireDefault(_pending);return _exports.default=class{constructor(){var _this$searchInput$val,_this$searchInput;_defineProperty(this,"selectors",{component:this.componentSelector(),toggle:'[data-toggle="dropdown"]',instance:'[data-region="instance"]',input:'[data-action="search"]',clearSearch:'[data-action="clearsearch"]',dropdown:this.dropdownSelector(),resultitems:'[role="option"]',viewall:"#select-all",combobox:'[role="combobox"]'}),_defineProperty(this,"matchedResults",[]),_defineProperty(this,"searchTerm",""),_defineProperty(this,"preppedSearchTerm",null),_defineProperty(this,"resultNodes",[]),_defineProperty(this,"currentNode",null),_defineProperty(this,"currentViewAll",null),_defineProperty(this,"dataset",null),_defineProperty(this,"datasetSize",0),_defineProperty(this,"component",document.querySelector(this.selectors.component)),_defineProperty(this,"instance",this.component.dataset.instance),_defineProperty(this,"toggle",this.component.querySelector(this.selectors.toggle)),_defineProperty(this,"searchInput",this.component.querySelector(this.selectors.input)),_defineProperty(this,"searchDropdown",this.component.querySelector(this.selectors.dropdown)),_defineProperty(this,"clearSearchButton",this.component.querySelector(this.selectors.clearSearch)),_defineProperty(this,"combobox",this.component.querySelector(this.selectors.combobox)),_defineProperty(this,"$component",(0,_jquery.default)(this.component)),this.setSearchTerms(null!==(_this$searchInput$val=null===(_this$searchInput=this.searchInput)||void 0===_this$searchInput?void 0:_this$searchInput.value)&&void 0!==_this$searchInput$val?_this$searchInput$val:""),this.registerClickHandlers(),null!==this.searchInput&&(this.registerInputHandlers(),this.registerChangeHandlers()),""!==this.getSearchTerm()&&this.clearSearchButton.classList.remove("d-none")}fetchDataset(){throw new Error("fetchDataset() must be implemented in ".concat(this.constructor.name))}filterDataset(dataset){throw new Error("filterDataset(".concat(dataset,") must be implemented in ").concat(this.constructor.name))}filterMatchDataset(){throw new Error("filterMatchDataset() must be implemented in ".concat(this.constructor.name))}renderDropdown(){throw new Error("renderDropdown() must be implemented in ".concat(this.constructor.name))}componentSelector(){throw new Error("componentSelector() must be implemented in ".concat(this.constructor.name))}dropdownSelector(){throw new Error("dropdownSelector() must be implemented in ".concat(this.constructor.name))}triggerSelector(){window.console.warning("triggerSelector() is deprecated. Consider using this.selectors.toggle")}async getDataset(){return this.dataset||(this.dataset=await this.fetchDataset()),this.datasetSize=this.dataset.length,this.dataset}getDatasetSize(){return this.datasetSize}getMatchedResults(){return this.matchedResults}setMatchedResults(result){this.matchedResults=result}getSearchTerm(){return this.searchTerm}getPreppedSearchTerm(){return this.preppedSearchTerm}setSearchTerms(result){this.searchTerm=result,this.preppedSearchTerm=result.toLowerCase()}getHTMLElements(){return this.updateNodes(),{searchDropdown:this.searchDropdown,currentViewAll:this.currentViewAll,searchInput:this.searchInput,clearSearchButton:this.clearSearchButton,trigger:this.component.querySelector(this.selectors.trigger)}}closeSearch(){let clear=arguments.length>0&&void 0!==arguments[0]&&arguments[0];this.toggleDropdown(),clear&&(this.clearSearchButton.classList.add("d-none"),this.setSearchTerms(""),this.searchInput.value="")}searchResultsVisible(){const{searchDropdown:searchDropdown}=this.getHTMLElements();return null!==searchDropdown.offsetParent}toggleDropdown(){arguments.length>0&&void 0!==arguments[0]&&arguments[0]?(0,_jquery.default)(this.toggle).dropdown("show"):(0,_jquery.default)(this.toggle).dropdown("hide")}updateNodes(){this.resultNodes=[...this.component.querySelectorAll(this.selectors.resultitems)],this.currentNode=this.resultNodes.find((r=>r.id===document.activeElement.id)),this.currentViewAll=this.component.querySelector(this.selectors.viewall),this.clearSearchButton=this.component.querySelector(this.selectors.clearSearch),this.searchInput=this.component.querySelector(this.selectors.input),this.searchDropdown=this.component.querySelector(this.selectors.dropdown)}registerClickHandlers(){this.component.addEventListener("click",this.clickHandler.bind(this))}registerChangeHandlers(){this.component.querySelector("#".concat(this.combobox.dataset.inputElement)).addEventListener("change",this.changeHandler.bind(this))}registerInputHandlers(){this.searchInput.addEventListener("input",(0,_utils.debounce)((async()=>{if(this.getSearchTerm()===this.searchInput.value&&this.searchResultsVisible())return void window.console.warn("Search term matches input value - skipping");this.setSearchTerms(this.searchInput.value);const pendingPromise=new _pending.default;""===this.getSearchTerm()?(this.toggleDropdown(),this.clearSearchButton.classList.add("d-none"),await this.filterrenderpipe()):(this.clearSearchButton.classList.remove("d-none"),await this.renderAndShow()),pendingPromise.resolve()}),300,{pending:!0}))}async filterrenderpipe(){this.updateNodes(),this.setMatchedResults(await this.filterDataset(await this.getDataset())),this.filterMatchDataset(),await this.renderDropdown(),await this.updateLiveRegion()}async renderAndShow(){this.setMatchedResults(await this.filterDataset(await this.getDataset())),await this.filterMatchDataset(),await this.renderDropdown(),this.toggleDropdown(!0),await this.updateLiveRegion()}async clickHandler(e){this.updateNodes(),e.target.closest(this.selectors.clearSearch)&&(this.closeSearch(!0),this.searchInput.focus(),this.searchInput.removeAttribute("aria-activedescendant")),""!==this.getSearchTerm()&&!this.getHTMLElements().searchDropdown.classList.contains("show")&&e.target.closest(this.selectors.input)&&await this.renderAndShow()}changeHandler(e){}async updateLiveRegion(){var _this$searchDropdown;if(null===(_this$searchDropdown=this.searchDropdown)||void 0===_this$searchDropdown||!_this$searchDropdown.id)return;const idParts=this.searchDropdown.id.split("-");if(idParts.length<3)return;const[,instanceId,id]=idParts,liveRegion=document.getElementById("combobox-status-".concat(instanceId,"-").concat(id));if(!liveRegion)return;const resultCount=this.getMatchedResults().length;let message;message=0===resultCount?await(0,_str.get_string)("noitemsfound","core"):1===resultCount?await(0,_str.get_string)("oneitemfound","core"):await(0,_str.get_string)("multipleitemsfound","core",resultCount),liveRegion.textContent=message,this.liveRegionTimeout&&clearTimeout(this.liveRegionTimeout),this.liveRegionTimeout=setTimeout((()=>{liveRegion.textContent="",this.liveRegionTimeout=null}),4e3)}},_exports.default}));

//# sourceMappingURL=search_combobox.min.js.map